import SwiftUI

struct TimerWidget: Widget {

    struct Data: WidgetData {
        var date: Date
    }

    private struct Content: View {
        var data: Data

        var body: some View {
            Text(data.date, style: .relative)
        }
    }

    func make() -> some View {
        Content(data: data)
    }

    var data: Data
}
